/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.model.entity;

import com.eeeab.eeeabsmobs.client.model.entity.ModelImmortalBase;
import com.eeeab.eeeabsmobs.sever.entity.impl.immortal.EntityImmortalGolem;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.world.entity.HumanoidArm;

public class ModelImmortalGolem
extends ModelImmortalBase<EntityImmortalGolem>
implements ArmedModel {
    public ModelImmortalGolem() {
        this.texHeight = 128;
        this.texWidth = 128;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this, "root");
        this.root.setPos(0.0f, 24.0f, 0.0f);
        this.upper = new AdvancedModelBox((AdvancedEntityModel)this, "upper");
        this.upper.setPos(0.0f, 0.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.upper);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this, "head");
        this.head.setPos(0.0f, -18.0f, 0.0f);
        this.upper.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(0, 0).addBox(-4.0f, -7.5f, -4.0f, 8.0f, 8.0f, 8.0f, -0.3f);
        this.head.setTextureOffset(34, 0).addBox(-4.0f, -6.5f, -4.0f, 8.0f, 8.0f, 8.0f, -0.6f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this, "body");
        this.body.setPos(0.0f, -18.0f, 0.0f);
        this.upper.addChild((BasicModelPart)this.body);
        this.body.setTextureOffset(11, 18).addBox(-3.5f, 0.0f, -2.0f, 7.0f, 10.0f, 4.0f, false);
        this.leftArm = new AdvancedModelBox((AdvancedEntityModel)this, "leftArm");
        this.leftArm.setPos(5.0f, 1.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.leftArm);
        this.leftArm.setTextureOffset(35, 20).addBox(-1.5f, -1.0f, -1.0f, 2.0f, 10.0f, 2.0f, false);
        this.setRotationAngle(this.leftArm, ModelImmortalGolem.toRadians(-90.0), 0.0f, 0.0f);
        this.rightArm = new AdvancedModelBox((AdvancedEntityModel)this, "rightArm");
        this.rightArm.setPos(-5.0f, 1.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.rightArm);
        this.rightArm.setTextureOffset(35, 20).addBox(-0.5f, -1.0f, -1.0f, 2.0f, 10.0f, 2.0f, false);
        this.setRotationAngle(this.rightArm, ModelImmortalGolem.toRadians(-90.0), 0.0f, 0.0f);
        this.lower = new AdvancedModelBox((AdvancedEntityModel)this, "lower");
        this.lower.setPos(0.0f, 0.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.lower);
        this.leftLeg = new AdvancedModelBox((AdvancedEntityModel)this, "leftLeg");
        this.leftLeg.setPos(2.0f, -9.0f, 0.1f);
        this.lower.addChild((BasicModelPart)this.leftLeg);
        this.leftLeg.setTextureOffset(1, 22).addBox(-1.0f, 1.0f, -1.1f, 2.0f, 8.0f, 2.0f, false);
        this.rightLeg = new AdvancedModelBox((AdvancedEntityModel)this, "rightLeg");
        this.rightLeg.setPos(-2.0f, -9.0f, 0.1f);
        this.lower.addChild((BasicModelPart)this.rightLeg);
        this.rightLeg.setTextureOffset(1, 22).addBox(-1.0f, 1.0f, -1.1f, 2.0f, 8.0f, 2.0f, false);
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    private void animate(EntityImmortalGolem entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float frame) {
        if (this.animator.setAnimation(EntityImmortalGolem.ATTACK_ANIMATION)) {
            this.animator.setStaticKeyframe(2);
            this.animator.startKeyframe(5);
            this.animator.rotate(this.root, ModelImmortalGolem.toRadians(-6.0), 0.0f, 0.0f);
            this.animator.rotate(this.head, 0.0f, 0.0f, 0.0f);
            this.animator.rotate(this.leftArm, ModelImmortalGolem.toRadians(-70.0), ModelImmortalGolem.toRadians(5.0), 0.0f);
            this.animator.rotate(this.rightArm, ModelImmortalGolem.toRadians(-70.0), ModelImmortalGolem.toRadians(-5.0), 0.0f);
            this.animator.endKeyframe();
            this.animator.startKeyframe(3);
            this.animator.rotate(this.root, ModelImmortalGolem.toRadians(6.0), 0.0f, 0.0f);
            this.animator.rotate(this.head, ModelImmortalGolem.toRadians(-30.0), 0.0f, 0.0f);
            this.animator.rotate(this.leftArm, ModelImmortalGolem.toRadians(40.0), ModelImmortalGolem.toRadians(12.0), 0.0f);
            this.animator.rotate(this.rightArm, ModelImmortalGolem.toRadians(40.0), ModelImmortalGolem.toRadians(-12.0), 0.0f);
            this.animator.endKeyframe();
            this.animator.resetKeyframe(2);
        }
        if (this.animator.setAnimation(EntityImmortalGolem.HURT_ANIMATION)) {
            this.animator.startKeyframe(3);
            this.animator.rotate(this.upper, ModelImmortalGolem.toRadians(2.5), 0.0f, ModelImmortalGolem.toRadians(-2.5));
            this.animator.rotate(this.rightArm, ModelImmortalGolem.toRadians(2.5), 0.0f, ModelImmortalGolem.toRadians(-2.5));
            this.animator.rotate(this.leftArm, ModelImmortalGolem.toRadians(2.5), 0.0f, ModelImmortalGolem.toRadians(-2.5));
            this.animator.rotate(this.root, ModelImmortalGolem.toRadians(2.5), 0.0f, ModelImmortalGolem.toRadians(-1.5));
            this.animator.move(this.upper, 0.0f, 1.0f, 0.0f);
            this.animator.move(this.head, 0.0f, 1.5f, 0.0f);
            this.animator.endKeyframe();
            this.animator.startKeyframe(3);
            this.animator.rotate(this.upper, ModelImmortalGolem.toRadians(-2.5), 0.0f, ModelImmortalGolem.toRadians(2.5));
            this.animator.rotate(this.rightArm, ModelImmortalGolem.toRadians(-2.5), 0.0f, ModelImmortalGolem.toRadians(2.5));
            this.animator.rotate(this.leftArm, ModelImmortalGolem.toRadians(-2.5), 0.0f, ModelImmortalGolem.toRadians(2.5));
            this.animator.rotate(this.root, ModelImmortalGolem.toRadians(-2.5), 0.0f, ModelImmortalGolem.toRadians(1.5));
            this.animator.move(this.upper, 0.0f, 1.0f, 0.0f);
            this.animator.move(this.head, 0.0f, 1.5f, 0.0f);
            this.animator.endKeyframe();
            this.animator.resetKeyframe(4);
        }
    }

    @Override
    protected Animation getSpawnAnimation() {
        return EntityImmortalGolem.SPAWN_ANIMATION;
    }

    @Override
    public void setupAnim(EntityImmortalGolem entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float frame) {
        this.animate(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, frame);
        this.faceTarget(netHeadYaw, headPitch, 1.0f, new AdvancedModelBox[]{this.head});
        float walkSpeed = 0.8f;
        float walkDegree = 0.8f;
        this.flap(this.root, walkSpeed, walkDegree * 0.05f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.leftLeg, walkSpeed, walkDegree * 1.2f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.rightLeg, walkSpeed, walkDegree * 1.2f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.leftArm, walkSpeed, walkDegree * 0.2f, false, 0.0f, -0.05f, limbSwing, limbSwingAmount);
        this.walk(this.rightArm, walkSpeed, walkDegree * 0.2f, true, 0.0f, -0.05f, limbSwing, limbSwingAmount);
        float speed = 0.08f;
        float degree = 0.05f;
        if (entity.m_6084_()) {
            this.walk(this.head, speed, degree, false, 0.5f, -0.05f, frame, 1.0f);
            this.walk(this.rightArm, speed, degree, true, 0.0f, -0.05f, frame, 1.0f);
            this.swing(this.rightArm, speed, degree, true, 0.0f, 0.0f, frame, 1.0f);
            this.walk(this.leftArm, speed, degree, false, 0.0f, -0.05f, frame, 1.0f);
            this.swing(this.leftArm, speed, degree, false, 0.0f, 0.0f, frame, 1.0f);
        }
        if (entity.isDangerous() && entity.getAnimation() != EntityImmortalGolem.SPAWN_ANIMATION) {
            this.setStaticRotationAngle(this.leftArm, ModelImmortalGolem.toRadians(20.0), ModelImmortalGolem.toRadians(25.0), 0.0f);
            this.setStaticRotationAngle(this.rightArm, ModelImmortalGolem.toRadians(20.0), ModelImmortalGolem.toRadians(-25.0), 0.0f);
        }
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.upper, (Object)this.lower, (Object)this.head, (Object)this.rightArm, (Object)this.leftArm, (Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        boolean flag = humanoidArm == HumanoidArm.RIGHT;
        AdvancedModelBox model$part = flag ? this.rightArm : this.leftArm;
        this.root.translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        model$part.translateAndRotate(poseStack);
        poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        this.offsetStackPosition(poseStack, flag);
    }

    private void offsetStackPosition(PoseStack translate, boolean isRightArm) {
        if (isRightArm) {
            translate.m_85837_(0.125, 0.1625, 0.0);
        } else {
            translate.m_85837_(-0.125, 0.1625, 0.0);
        }
    }

    @Override
    protected double handsOffset() {
        return -90.0;
    }
}

